#cls;
#$st = Get-Date;
# 2019-Jan-16. Created by Maxim T. 
# 2024-Sep 28. Converted by gsbaker (using Microsoft Copilot)to run on Windows 11 for ARM by using the Powershell module "ImportExcel" instead of "Microsoft.ACE.OLEDB.12.0".
# *** NOTE *** The ImportExcel module does not come pre-installed with Windows 11 for ARM. It’s a separate PowerShell module that you need to install manually. 
#              To install the ImportExcel module for all users on Windows 11 for ARM, you need to run PowerShell with administrative privileges. Here are the steps:
#                 1. Open PowerShell as Administrator:
#                     - Press Win + X and select Windows Terminal (Admin) or Windows PowerShell (Admin).
#                 2. Install the ImportExcel Module:
#                     - Run the following command to install the module for all users:
#                              Install-Module -Name ImportExcel -Scope AllUsers
#              This command needs to be executed only one time.  It installs the ImportExcel module for all users on the system, making it available to any user account.
#                                         
$scriptPath = Split-Path -parent $MyInvocation.MyCommand.Definition; 
. ($scriptPath + "\psFunctions.ps1");     # Adding script with reusable functions
. ($scriptPath + "\psSetVariables.ps1");  # Adding script to assign values to common variables

$logFile        = $scriptPath + "\Log\" + $MyInvocation.MyCommand.Name.Replace(".ps1",".txt"); 
(Get-Date).ToString("HH:mm:ss") + " --- Starting script " + $MyInvocation.MyCommand.Name | Out-File $logFile -Encoding OEM; # starting logging to file.
$logSummary = (Get-Date).ToString("HH:mm:ss") + " Script: ExtractExcelData".PadRight(28);

if ($config.IndexOf("<ExcelSourceFile>") -eq -1) {Write-Host "*** Error. Please specify <ExcelSourceFile> parameter value in psConfig.txt file" -ForegroundColor red; exit(1);}
$excelSource=""; $excelSource = ($config | Select-Object -Index(($config.IndexOf("<ExcelSourceFile>"))+1)).Replace("</ExcelSourceFile>","");
if (!(Test-Path $excelSource)) {Write-Host "*** Error. <ExcelSourceFile> parameter value in psConfig.txt file is $excelSource, but such file does not exists" -ForegroundColor red; exit(1);}

# ###################################################################################################
# Config
# ###################################################################################################
$outFile = $psDataFolder + "\Config.csv"; 
$excelData = Import-Excel -Path $excelSource -WorksheetName "Config"
$f="MinDate,TrackCash,RefreshTime".Replace(",",$colSep) + $eol; #file header
if ($excelData.Count -eq 0) {Write-Host "No config record found" -ForegroundColor Red; exit(1);}; # Just one line

  # MinDate is being read as a serial date number.  Convert it to a DateTime object
  $minDate = ""
  if ($excelData[0].MinDate -ne $null) {
    try {
      $dateValue = [datetime]::FromOADate([double]$excelData[0].MinDate)
      $minDate = $dateValue.ToString("yyyy-MM-dd")
    } catch {Write-Host "*** Error.  Failed to parse MinDate.  The Date value in Config tab of the Excel source file is $($excelData[0].MinDate).  The variable dateValue is $($dateValue) and minDate is $($minDate) " -ForegroundColor red; exit(1);}
  }

$f += $minDate + $colSep + $excelData[0].TrackCash.ToString().Replace($colSep," ") + $colSep + (Get-Date -Format "MMM-dd, HH:mm");
$f | Out-File $outFile -Encoding OEM; #output file

# ###################################################################################################
# ReportCurrency
# ###################################################################################################
$outFile = $psDataFolder + "\ReportCurrency.csv"; 
$excelData = Import-Excel -Path $excelSource -WorksheetName "ReportCurrency"
$f="ReportCurrency,CurrencyID".Replace(",",$colSep) + $eol; #file header
foreach ($row in $excelData) {
  $col1 = $row.ReportCurrency.ToString().Replace($colSep," ").ToUpper(); if ($col1 -eq "") {continue;}
  if ($col1 -eq "*ORIGINAL*") {$col1 = $row.ReportCurrency.ToString();}
  # Check remaining columns for null values  
  $colCurrID = if($row.CurrencyID -ne $null) {$row.CurrencyID.tostring().replace($colSep," ") } else{""}

  $f += $col1 + $colSep + $colCurrID + $eol;
}
$f = $f.Substring(0, $f.Length-$eol.Length); # Removing last 2 characters that are end of line
$f | Out-File $outFile -Encoding OEM; #output file

# ###################################################################################################
# Account
# ###################################################################################################
$accList = @(); $accCurrList = @(); # Creating Account/Currency arrays that will be used while building Transactions extract
$outFile = $psDataFolder + "\Account.csv"; 
$excelData = Import-Excel -Path $excelSource -WorksheetName "Account"
$f="Account,Portfolio,Tax,Currency,Active,AccountGroup1,AccountGroup2,AccountGroup3".Replace(",",$colSep) + $eol; #file header
foreach ($row in $excelData) {
  $col1 = $row.Account.ToString().Replace($colSep," "); if ($col1 -eq "") {continue;}
  # Check remaining columns for null values  
  $colPortfolio = if($row.Portfolio -ne $null) {$row.Portfolio.tostring().replace($colSep," ") } else{""}
  $colTax = if($row.Tax -ne $null) {$row.Tax.tostring().replace($colSep," ") } else{""}
  $colCurrency = if($row.Currency -ne $null) {$row.Currency.tostring().replace($colSep," ") } else{""}
  $colActive = if($row.Active -ne $null) {$row.Active.tostring().replace($colSep," ") } else{""}
  $colAcctGrp1 = if($row."Account Group 1" -ne $null) {$row."Account Group 1".tostring().replace($colSep," ") } else{""}
  $colAcctGrp2 = if($row."Account Group 2" -ne $null) {$row."Account Group 2".tostring().replace($colSep," ") } else{""}
  $colAcctGrp3 = if($row."Account Group 3" -ne $null) {$row."Account Group 3".tostring().replace($colSep," ") } else{""}
    
  $accList += $col1.ToLower(); $accCurrList += $colCurrency.ToUpper();
  $f += $col1 + $colSep + $colPortfolio + $colSep + $colTax + $colSep + $colCurrency + $colSep + $colActive `
     + $colSep + $colAcctGrp1  + $colSep + $colAcctGrp2 + $colSep + $colAcctGrp3 + $eol;
}
$f = $f.Substring(0, $f.Length-$eol.Length); # Removing last 2 characters that are end of line
$f | Out-File $outFile -Encoding OEM; #output file

# ###################################################################################################
# Allocation
# ###################################################################################################
$outFile = $psDataFolder + "\Allocation.csv"; 
$excelData = Import-Excel -Path $excelSource -WorksheetName "Allocation"
$f="Allocation,TargetPercent,Index".Replace(",",$colSep) + $eol; #file header
foreach ($row in $excelData) {
  $col1 = $row.Allocation.ToString().Replace($colSep," "); if ($col1 -eq "") {continue;}
  # Check remaining columns for null values  
  $colTargetPercent = if($row.TargetPercent -ne $null) {$row.TargetPercent.tostring().replace($colSep," ") } else{""}
  $colIndex = if($row.Index -ne $null) {$row.Index.tostring().replace($colSep," ") } else{""}
  
  $f += $col1 + $colSep + $colTargetPercent + $colSep + $colIndex + $eol;
}
$f = $f.Substring(0, $f.Length-$eol.Length); # Removing last 2 characters that are end of line
$f | Out-File $outFile -Encoding OEM; #output file

# ###################################################################################################
# Symbol
# ###################################################################################################
$sArray=@(); $allocArray=@();
$outFile = $psDataFolder + "\Symbol.csv"; 
$excelData = Import-Excel -Path $excelSource -WorksheetName "Symbol"
$f="Symbol,SymbolName,Currency,MER,Allocation,SymbolGroup1,SymbolGroup2,SymbolGroup3,Region,CurrencyBase".Replace(",",$colSep) + $eol; #file header
foreach ($row in $excelData) {
  $col1 = $row.Symbol.Replace($colSep," "); if ($col1 -eq "") {continue;}
  # Check remaining columns for null values  
  $colSymbolName = if($row.SymbolName -ne $null) {$row.SymbolName.tostring().replace($colSep," ") } else{""}
  $colCurrency = if($row.Currency -ne $null) {$row.Currency.tostring().replace($colSep," ") } else{""}
  $colMER = if($row.MER -ne $null) {$row.MER.tostring().replace($colSep," ") } else{""}
  $colAllocation = if($row.Allocation -ne $null) {$row.Allocation.tostring().replace($colSep," ") } else{""}
  $colSymGrp1 = if($row.SymbolGroup1 -ne $null) {$row.SymbolGroup1.tostring().replace($colSep," ") } else{""}
  $colSymGrp2 = if($row.SymbolGroup2 -ne $null) {$row.SymbolGroup2.tostring().replace($colSep," ") } else{""}
  $colSymGrp3 = if($row.SymbolGroup3 -ne $null) {$row.SymbolGroup3.tostring().replace($colSep," ") } else{""}
  $colRegion = if($row.Region -ne $null) {$row.Region.tostring().replace($colSep," ") } else{""}
  $colCurrBase = if($row.colCurrBase -ne $null) {$row.colCurrBase.tostring().replace($colSep," ") } else{""}
    
  $f += $col1 + $colSep + $colSymbolName + $colSep + $colCurrency + $colSep + $colMER + $colSep + $colAllocation + $colSep `
     + $colSymGrp1  + $colSep + $colSymGrp2 + $colSep + $colSymGrp3 + $colSep + $colRegion + $colSep + $colCurrBase + $eol;
  
  $sArray += $col1; $allocArray += $colAllocation;
}
$f = $f.Substring(0, $f.Length-$eol.Length); # Removing last 2 characters that are end of line
$f | Out-File $outFile -Encoding OEM; #output file

# ###################################################################################################
# SymbolSector
# ###################################################################################################
$outFile = $psDataFolder + "\SymbolSector.csv"; 
$excelData = Import-Excel -Path $excelSource -WorksheetName "SymbolSector"
$f="Symbol,Sector,Percent,Sensitivity".Replace(",",$colSep) + $eol; #file header
foreach ($row in $excelData) {
  $col1 = $row.Symbol.ToString().Replace($colSep," "); if ($col1 -eq "") {continue;}
  # Check remaining columns for null values  
  $colSector = if($row.Sector -ne $null) {$row.Sector.tostring().replace($colSep," ") } else{""}
  $colPercent = if($row.Percent -ne $null) {$row.Percent.tostring().replace($colSep," ") } else{""}
  $colSensitivity = if($row.Sensitivity -ne $null) {$row.Sensitivity.tostring().replace($colSep," ") } else{""}

  $f += $col1 + $colSep + $colSector + $colSep + $colPercent + $colSep + $colSensitivity + $eol;
}
$f = $f.Substring(0, $f.Length-$eol.Length); # Removing last 2 characters that are end of line
$f | Out-File $outFile -Encoding OEM; #output file

# ###################################################################################################
# SymbolAllocation
# ###################################################################################################
$outFile = $psDataFolder + "\SymbolAllocation.csv"; 
$sAllocArray=@();
$excelData = Import-Excel -Path $excelSource -WorksheetName "SymbolAllocation"
$f="Symbol,Allocation,Percent".Replace(",",$colSep) + $eol; #file header

foreach ($row in $excelData) {
  $col1 = if ($row.Symbol -ne $null) { $row.Symbol.ToString().Replace($colSep," ") } else { "" }
  if ($col1 -eq "") { continue; }
  # Check remaining columns for null values  
  $colAlloc = if ($row.Allocation -ne $null) { $row.Allocation.ToString().Replace($colSep," ") } else { "" }
  $colPercent = if ($row.Percent -ne $null) { $row.Percent.ToString().Replace($colSep," ") } else { "" }

  $f += $col1 + $colSep + $colAlloc + $colSep + $colPercent + $eol;

  if (!($sAllocArray -contains $col1)) {$sAllocArray+=$col1;}
}
# add Symbols from Symbol sheet to SymbolAllocation array
for ($i=0; $i -lt $sArray.Length; $i++) {
    if (!($sAllocArray -contains $sArray[$i] )) {
          $f += $sArray[$i] + $colSep + $allocArray[$i] + $colSep + "1"  + $eol;
    }
}
$f = $f.Substring(0, $f.Length-$eol.Length); # Removing last 2 characters that are end of line
$f | Out-File $outFile -Encoding OEM; #output file

# ###################################################################################################
# TransType
# ###################################################################################################
$transTypeList = @(); $transTypeBVList = @(); $transSortOrderList = @(); # Creating TransactionType + BookValue+TransactionOrder arrays that will be used while building Transactions extract
$outFile = $psDataFolder + "\TransType.csv"; 
$excelData = Import-Excel -Path $excelSource -WorksheetName "TransType"
$f="TransType,IgnoreQtyFlag,TransFeeSign,CashAmntSign,BookValueSign,QtySign,DistribReturnOfCapitalFlag,DistribCapGainReinvstdFlag,DividendFlag,DepositTransSign,CashImpactSign,SellFlag,WithholdingTaxFlag,FeeFlag,ExternalImpactSymbolSign,ExternalImpactPortfolioSign,ExternalImpactPortfolioSign2,CashFlag,ExchRateFlag,ShowForSalesReport,TransTypeGroup".Replace(",",$colSep) + $eol; #file header

foreach ($row in $excelData) {
  $col1 = $row.TransType.ToString().Replace($colSep," "); if ($col1 -eq "") {continue;}
  $transTypeList += $col1.ToLower(); $transTypeBVList += $row.BookValueSign.ToString(); $transSortOrderList += $row.TransSortOrder.ToString();
  $f += $col1 `
  + $colSep + $row.IgnoreQtyFlag.ToString()     + $colSep + $row.TransFeeSign.ToString()               + $colSep + $row.CashAmntSign.ToString()               + $colSep + $row.BookValueSign.ToString() `
  + $colSep + $row.QtySign.ToString()           + $colSep + $row.DistribReturnOfCapitalFlag.ToString() + $colSep + $row.DistribCapGainReinvstdFlag.ToString() + $colSep + $row.DividendFlag.ToString() `
  + $colSep + $row.DepositTransSign.ToString()  + $colSep + $row.CashImpactSign.ToString()             + $colSep + $row.SellFlag.ToString()                   + $colSep + $row.WithholdingTaxFlag.ToString() `
  + $colSep + $row.FeeFlag.ToString()           + $colSep + $row.ExternalImpactSymbolSign.ToString()   + $colSep + $row.ExternalImpactPortfolioSign.ToString()+ $colSep + $row.ExternalImpactPortfolioSign2.ToString() `
  + $colSep + $row.CashFlag.ToString()          + $colSep + $row.ExchRateFlag.ToString()               + $colSep + $row.ShowForSalesReport.ToString()         + $colSep + $row.TransTypeGroup.ToString().Replace($colSep," ") `
  + $eol;
}
$f = $f.Substring(0, $f.Length-$eol.Length); # Removing last 2 characters that are end of line
$f | Out-File $outFile -Encoding OEM; #output file

# ###################################################################################################
# Transactions
# ###################################################################################################
$outFile = $psDataFolder + "\TransactionsInExcel.csv"; 
$excelData = Import-Excel -Path $excelSource -WorksheetName "Transactions"
$f="Account,Date,TransType,TransSubType,Symbol,Qty,Price,Fee,ExchRate,Comment,CostBasisOverride,AccruedInterest,ExchRateRpt1Override,ExchRateRpt2Override,ExchRateRpt3Override,TotalAmnt,CashImpact,QtyChange,TransID,BookValueSign,TransSortOrder,CostBasisImpact".Replace(",",$colSep) + $eol; #file header

foreach ($row in $excelData) {

  $col1 = $row.Account.ToString().Replace($colSep," "); if ($col1 -eq "") {continue;}
  
  # The transaction dates are being read as serial date numbers. Convert them to a DateTime object
  $colDate = ""
  if ($row.Date -ne $null) {
    try {
      $dateValue = [datetime]::FromOADate([double]$row.Date)
      $colDate = $dateValue.ToString("yyyy-MM-dd")
    } catch {Write-Host "*** Error.  Failed to parse Transaction date.  The Date value in Transactions tab of the Excel source file is $($row.Date)" -ForegroundColor red; exit(1);}
  }
  # Check remaining columns for null values  
  $colTranType = if($row.TransType -ne $null) {$row.TransType.tostring().replace($colSep," ") } else{""}
  $colTranSub = if($row.TransSubType -ne $null) {$row.TransSubType.tostring().replace($colSep," ") } else{""}
  $colSymbol = if($row.Symbol -ne $null) {$row.Symbol.tostring().replace($colSep," ") } else{""}
  $colQty = if($row.Qty -ne $null) {$row.Qty.tostring().replace($colSep," ") } else{""}
  $colPrice = if($row.Price -ne $null) {$row.Price.tostring().replace($colSep," ") } else{""}
  $colFee = if($row.Fee -ne $null) {$row.Fee.tostring().replace($colSep," ") } else{""}
  $colExchRate = if($row.ExchRate -ne $null) {$row.ExchRate.tostring().replace($colSep," ") } else{""}
  $colComment = if($row.Comment -ne $null) {$row.Comment.tostring().replace($colSep," ") } else{""}
  $colCBOver = if($row.CostBasisOverride -ne $null) {$row.CostBasisOverride.tostring().replace($colSep," ") } else{""}
  $colAccInt = if($row.AccruedInterest -ne $null) {$row.AccruedInterest.tostring().replace($colSep," ") } else{""}
  $colFXRpt1Over = if($row.ExchRateRpt1Override -ne $null) {$row.ExchRateRpt1Override.tostring().replace($colSep," ") } else{""}
  $colFXRpt2Over = if($row.ExchRateRpt2Override -ne $null) {$row.ExchRateRpt2Override.tostring().replace($colSep," ") } else{""}
  $colFXRpt3Over = if($row.ExchRateRpt3Override -ne $null) {$row.ExchRateRpt3Override.tostring().replace($colSep," ") } else{""}
  $colTotalAmnt = if($row.TotalAmnt -ne $null) {$row.TotalAmnt.tostring().replace($colSep," ") } else{""}
  $colCashImp = if($row.CashImpact -ne $null) {$row.CashImpact.tostring().replace($colSep," ") } else{""}
  $colQtyChg = if($row.QtyChange -ne $null) {$row.QtyChange.tostring().replace($colSep," ") } else{""}
  $colTransID = if($row.TransID -ne $null) {$row.TransID.tostring().replace($colSep," ") } else{""}
  
  # Calculation columns from previously built arrays
  $accountCurrency = $accCurrList[$accList.IndexOf($col1.ToLower())].ToUpper(); 
  $bvs = $transTypeBVList[$transTypeList.IndexOf($row.TransType.ToString().ToLower())]; 
  $tso = $transSortOrderList[$transTypeList.IndexOf($row.TransType.ToString().ToLower())];

  $f += $col1 `
  + $colSep + $colDate        + $colSep  +  $colTranType   + $colSep + $colTranSub   + $colSep + $colSymbol `
  + $colSep + $colQty         + $colSep  +  $colPrice      + $colSep + $colFee       + $colSep + $colExchRate `
  + $colSep + $colComment     + $colSep  +  $colCBOver     + $colSep + $colAccInt    + $colSep + $colFXRpt1Over `
  + $colSep + $colFXRpt2Over  + $colSep  +  $colFXRpt3Over + $colSep + $colTotalAmnt + $colSep + $ColCashImp `
  + $colSep + $colQtyChg      + $colSep  +  $colTransID    + $colSep + $bvs          + $colSep + $tso            + $colSep + "0" `
  + $eol;

  #+ $colSep + $accountCurrency  + $colSep + "0" + $colSep + $row.CBI `
}
 
$f = $f.Substring(0, $f.Length-$eol.Length); # Removing last 2 characters that are end of line
$f | Out-File $outFile -Encoding OEM; #output file

# ###################################################################################################
# Report
# ###################################################################################################
$outFile = $psDataFolder + "\Report.csv";
$f="Report"+$eol+"Report";
$f | Out-File $outFile -Encoding OEM; #output file

# ###################################################################################################
# CompareTo
# ###################################################################################################
$outFile = $psDataFolder + "\CompareTo.csv"; 
$excelData = Import-Excel -Path $excelSource -WorksheetName "CompareTo"
$f="ID,CompareTo,Symbol,AnnlAdj%".Replace(",",$colSep) + $eol; #file header

foreach ($row in $excelData) {
  $col1 = $row.ID.ToString().Replace($colSep," "); if ($col1 -eq "") {continue;}
  # Check remaining columns for null values  
  $colCompareTo = if($row.CompareTo -ne $null) {$row.CompareTo.tostring().replace($colSep," ") } else{""}
  $colSymbol = if($row.Symbol -ne $null) {$row.Symbol.tostring().replace($colSep," ") } else{""}
  $colAnnlAdj = if($row.'AnnlAdj%' -ne $null) {$row.'AnnlAdj%'.tostring().replace($colSep," ") } else{""}
   
  $f += $col1 + $colSep + $colCompareTo + $colSep + $colSymbol + $colSep + $colAnnlAdj  + $eol;
}

$f = $f.Substring(0, $f.Length-$eol.Length); # Removing last 2 characters that are end of line
$f | Out-File $outFile -Encoding OEM; #output file

# ###################################################################################################

$duration = (NEW-TIMESPAN -Start $startTime -End (Get-Date)).TotalSeconds.ToString("#,##0") + " sec.";
(Get-Date).ToString("HH:mm:ss") + " --- Finished ExtractExcelData. Duration: $duration`r`n" | Out-File $logFile -Encoding OEM -append;
$logSummary + ". Duration: $duration";
#"Duration: " + (NEW-TIMESPAN -Start $st -End (Get-Date)).TotalSeconds.ToString("#,##0") + " sec.";